---
aliases : Multi-cloud, Multi Cloud
---
- Priority growth area in strategy cascade
	- ![[FY24 strategy cascade.png]] 
- 3 high revenue orgs in ISG
	- Servers - $3B+ per quarter - PowerEdge
	- Storage - $2B+ per quarter - Primary storage and Unstructured storage
	- HCI HyperConverged Infrastructure - $1B+ per quarter
- Dell blog - Project Alpine: [A Better Way to Multi-Cloud | Dell USA](https://www.dell.com/en-us/blog/a-better-way-to-multi-cloud/?dgc=SM&cid=170852&lid=spr6304684912&RefID=dtw22_sm6304684912&linkId=151330689)
	- Cloud storage concepts:
		- **Block storage** takes a file apart into singular blocks of data and then stores these blocks as separate pieces of data. Each piece of data has a different address, so they don't need to be stored in a file structure.
			- Block storage is when our systems are setup as a SAN to serve direct access from servers to disks​. Very good for transactional, low-latency workloads like databases, virtual machines, and containers. ​Examples: PowerStore, PowerMax, Unity (although some of these support file as well)​
		- **File storage** stores data as a single piece of information in a folder to help organize it among other data. This is also called hierarchical storage, imitating the way that paper files are stored. When you need access to data, your computer system needs to know the path to find it.
			- File storage is when our systems serve access to a NAS share in which files can be organized and managed and accessed from anywhere via NFS, FTP, SMB, and S3. This is good for a lot of small files or a collection of very large files for use cases such as consolidation of file shares or vertical centric applications like video, graphics, 3D models, etc  Example: PowerScale​
		- **Object storage** takes each piece of data and designates it as an object. Data is kept in separate storehouses versus files in folders and is bundled with associated metadata and a unique identifier to form a storage pool.​
			- Object storage is when our systems serve access to S3 buckets on our system using the same language many cloud applications – great for S3 applications, AI/Analytics workloads (fast), or archives (cheap/deep). Example: ECS, ObjectScale
- Caitlin Gordon's org
	- Networking 
		- [[Prateesh Sharma]], [[Srija Dasika]] 
		- [[Kshitij Tambe]]
		- Murali Keloth
		- Damon Earley
- [[Yuri Streciwik]]
- [[Kshitij Tambe]]
- [[Cloudify-Dell acquisition]]
- ==Key Links on APEX multi-cloud education==
	- [Cross-Platform Software & Solutions - Product Lenses - All Items (sharepoint.com)](https://dell.sharepoint.com/sites/CommonOperatingEnvironmentPdM/Lists/Product%20Lenses/AllItems.aspx)
		- [Weekly meeting multi-cloud](https://dell.sharepoint.com/sites/CommonOperatingEnvironmentPdM/Lists/Product%20Lenses/AllItems.aspx?sortField=Scheduled&isAscending=true&viewid=aaada839%2D9a15%2D49b4%2Da195%2Db2348767e7ab "https://dell.sharepoint.com/sites/commonoperatingenvironmentpdm/lists/product%20lenses/allitems.aspx?sortfield=scheduled&isascending=true&viewid=aaada839%2d9a15%2d49b4%2da195%2db2348767e7ab")
		- [Zoom recording multi-cloud](https://dell.zoom.us/rec/share/rcIYTTif6vXeNhHLb2FBoWa6h2AyLvw8UIpBsmEcRBZyDypLBt5d6RQpHBJjsL-k.bE8swyl6wvzEPJTy "https://dell.zoom.us/rec/share/rciyttif6vxenhhlb2fbowa6h2aylvw8uipbsmecrbzydyplbt5d6rqphbjjsl-k.be8swyl6wvzepjty") Password: tGH#6tda
	- [Analyst Landscape - 2022 VAU's - All Documents (sharepoint.com)](https://dell.sharepoint.com/sites/analystlandscape/Shared%20Documents/Forms/AllItems.aspx?isAscending=false&id=%2Fsites%2Fanalystlandscape%2FShared%20Documents%2F2022%20VAU%27s&sortField=Created&viewid=a5555389%2D7d2f%2D467f%2D9c5f%2Dd739bd5bddab)
	- 

##### Unstructured data storage - UDS
- Key tradeoffs to consider include:
	- **Scalability**: Object storage systems are highly scalable, allowing for large volumes of unstructured data to be stored and accessed easily. However, they may not be as fast or efficient as other storage systems, and they can be more expensive.
	- **Performance**: File systems and content-addressed storage (CAS) are generally faster and more efficient than object storage, but they may not be as scalable or cost-effective.
	- **Accessibility**: File systems are typically the most accessible storage system for unstructured data, as they are often used by operating systems and can be accessed directly by applications. Object storage can also be accessed through APIs, but this may require additional development work.
	- **Cost**: Object storage systems can be more expensive than file systems or CAS, but they offer more scalability and flexibility. CAS systems are typically less expensive than other options, but they may not be as performant or scalable.
	- **Data** protection: All storage systems should include data protection features such as backup and disaster recovery. Object storage and CAS systems often have built-in data protection features, while file systems may require additional tools or software to ensure data protection.

### Analytics
1. Revenue dashboard - [Apex Sales Dashboard - Power BI](https://app.powerbi.com/groups/me/reports/121f9540-f6aa-4332-bcd2-9ebe3776e3a1/ReportSectionbfc6f6c7f35cd5622a10)
2. Investor feedback
	1. [[2022-6-27 - APEX & Cloud Analyst Insights.pptx]]

### APEX Navigator - Cirrus
This is a great start and love seeing the progress on APEX Navigator. I wanted to know more on use cases that we are targeting. How does the performance compare when customers use AWS EBS vs when they use PowerFlex in AWS? What key use cases will we see customers prefer PowerFlex in AWS over AWS EBS? What are those top customer value props?
Sumedh (SooMayDh) 01:57 PM 
PowerFlex in AWS offers higher performance, and better (cross-AZ/Region) scalability. The PowerFlex internal team measurements have been reproduced by customers in AWS, and they like it.

As for the use cases, we begin at hourly/daily/weekly data movements which are not permanent migrations. Think dev and test, AI model train / inferencing. Think cross-geo data availability. More use-cases will essentially become embedded in solutions that will use the Navigator.

AWS already has S3, Elastic Block and Elastic File. Azure has similar storage services. Are we competing against these for storage market share? If not, who are our direct competitors?
Sumedh (SooMayDh) 01:24 PM 
With PowerFlex in AWS, we will compete with EBS. With PowerScale, we will compete with EFS. But, more importantly, our customers are asking for the Dell storage stacks in clouds like AWS and Azure. Why? Our storage is generally superior to what the public clouds offer.

### UDS OneFS software app to manage storage
[Product Management UDS (sharepoint.com)](https://dell.sharepoint.com/sites/OneUDS/SitePages/00-002-Product-Management-UDS.aspx)
[[OneFS]]

##### Org structure
- [Organizational Charts (sharepoint.com)](https://dell.sharepoint.com/sites/ISGPortfolioManagement/SitePages/Organizational-Charts.aspx)
- ![[Pasted image 20230425171011.png|1000]]
- ![[Pasted image 20230425171120.png|1000]]

### OneFS PowerScale vision
![[Pasted image 20230612152236.png]]